<?php
require_once('utility.php');
function setup_nat($argv) {
	global $DTASCFG_XML_FILE, $BACKEND;

	$xml = simplexml_load_file($DTASCFG_XML_FILE);

	$esxi_ip = chop($xml->esxi->ip);
	$esxi_username = chop($xml->esxi->username);
	$esxi_password = $xml->esxi->password;

	$sandbox_controller_vmpath = chop($xml->sandbox_controller->image_path);
	$sandbox_controller_prefix = chop($xml->sandbox_controller->prefix);
	$sandbox_controller_admin_username = chop($xml->sandbox_controller->admin_username);
	$sandbox_controller_admin_password = $xml->sandbox_controller->admin_password;

	$datastore_dir = dirname(dirname($sandbox_controller_vmpath));
	$nat_vmdir = $datastore_dir . '/nat';
	$nat_vmpath = $nat_vmdir . '/nat.vmx';
	$nat_isopath = $datastore_dir . '/nat.iso';

	$init_nic = chop($xml->sandbox_controller->init_nic);
	$init_ipaddr = chop($xml->sandbox_controller->init_ipaddr);
	$init_netmask = chop($xml->sandbox_controller->init_netmask);
	$ctrl_nic = chop($xml->sandbox_controller->ctrl_nic);
	$ctrl_ipaddr = chop($xml->sandbox_controller->ctrl_ipaddr);
	$ctrl_netmask = chop($xml->sandbox_controller->ctrl_netmask);
	$ctrl_gateway = chop($xml->sandbox_controller->ctrl_gateway);
	$sandbox_default_net = chop($xml->sandbox->default_net);
	$sandbox_default_netmask = chop($xml->sandbox->default_netmask);
	$sandbox_default_gateway = chop($xml->sandbox->default_gateway);
	$sandbox_controller_dir = chop($xml->sandbox_controller->ctrl_dir);
	
    // Escape variables since then they will be used in command line
    $escaped_esxi_username = escapeshellarg($esxi_username);
    $escaped_esxi_password = escapeshellarg($esxi_password);
    $escaped_sandbox_controller_admin_username = escapeshellarg($sandbox_controller_admin_username);
    $escaped_sandbox_controller_admin_password = escapeshellarg($sandbox_controller_admin_password);
    
    /* execute main function */

    
	/* remove nat from datastore */
	unset($result_array);
	exec("$BACKEND list_all_esxi_vms $esxi_ip $escaped_esxi_username $escaped_esxi_password 2>&1", $result_array, $return_value);
	foreach($result_array as $line) {
		if(strcmp($line, $nat_vmpath) == 0) {
			debug_print( "power-off NAT: $nat_vmpath ..." ) ;
			stop_vm_and_wait($esxi_ip, $esxi_username, $esxi_password, $nat_vmpath);

			debug_print( "unregister NAT: $nat_vmpath ..." ) ;
			unset($result_array);
			exec("$BACKEND unregister_esxi_vm $esxi_ip $escaped_esxi_username $escaped_esxi_password $nat_vmpath 2>&1", $result_array, $return_value);
			if($return_value != 0) print_error($result_array, $return_value);
		}
	}
	
	
	debug_print( "delete $nat_vmpath ..." ) ;
	unset($result_array);
	exec("$BACKEND ssh_cmd_to_esxi_server $esxi_ip $escaped_esxi_username $escaped_esxi_password \"rm -rf \\\\\\\"$nat_vmdir\\\\\\\"\" 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);

	
	/* copy nat-related files to esxi */
	debug_print( "create $nat_vmpath ..." ) ;
	unset($result_array);
	exec("$BACKEND ssh_cmd_to_esxi_server $esxi_ip $escaped_esxi_username $escaped_esxi_password \"mkdir -p \\\\\\\"$nat_vmdir\\\\\\\"\" 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);

	
	debug_print( "copy \"nat.iso\" to \"$nat_isopath\" ..." ) ;
	unset($result_array);
	exec("$BACKEND scp_put_to_esxi_server $esxi_ip $escaped_esxi_username $escaped_esxi_password " . dirname(__FILE__) . "/../nat.iso $nat_isopath 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);
	
	
	debug_print( "copy \"nat.vmx\" to \"$nat_vmdir\" ..." ) ;
	unset($result_array);
	exec("$BACKEND scp_put_to_esxi_server $esxi_ip $escaped_esxi_username $escaped_esxi_password " . dirname(__FILE__) . "/../nat.vmx $nat_vmdir 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);
	
	
	debug_print( "modify file: $nat_vmpath ..." ) ;
	debug_print( "     ide1:0.fileName = \"$nat_isopath\"" ) ;
	unset($result_array);
	exec("sh " . dirname(__FILE__) . "/ssh_cmd.sh $esxi_ip $escaped_esxi_username $escaped_esxi_password \"sed -i '/ide1:0.fileName = .*/d' $nat_vmpath\" 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);
	unset($result_array);
	exec("sh " . dirname(__FILE__) . "/ssh_cmd.sh $esxi_ip $escaped_esxi_username $escaped_esxi_password \"echo 'ide1:0.fileName = \\\\\\\"$nat_isopath\\\\\\\"' >> $nat_vmpath\" 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);

	
	/* create nat */
	debug_print( "register NAT: $nat_vmpath ..." ) ;
	unset($result_array);
	exec("$BACKEND register_esxi_vm $esxi_ip $escaped_esxi_username $escaped_esxi_password $nat_vmpath 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);

	
	/* prepare nat done, start it */
	debug_print( "power-on NAT: $nat_vmpath ..." ) ;
	start_vm_and_wait($esxi_ip, $esxi_username, $esxi_password, $nat_vmpath);
	
	
	/* sandbox controller should power on, but we try to power on it again */
	debug_print( "power-on sandbox_controller again for stability: $sandbox_controller_vmpath ..." ) ;
	start_vm_and_wait($esxi_ip, $esxi_username, $esxi_password, $sandbox_controller_vmpath);

	
	$controller_vix_vmpath = get_vm_vixpath($esxi_ip, $esxi_username, $esxi_password, $sandbox_controller_prefix);
	debug_print( "get controller_vix_vmpath: $controller_vix_vmpath" ) ;
	

	/* setting network configuration for eth1 */
	debug_print( "create \"tmp-ifcfg-eth1\"" ) ;
	$result_array = array();
	array_push($result_array, "fopen error");
    $fh_ifcfg_eth1 = fopen(dirname(__FILE__) . "/tmp-ifcfg-eth1", "w");	
	if($fh_ifcfg_eth1 === false) print_error($result_array, 1);

	$contentString = "DEVICE=\"eth1\"\nONBOOT=yes\nBOOTPROTO=static\n";
	$result_array = array();
	array_push($result_array, "fwrite error");
    if(fwrite($fh_ifcfg_eth1, $contentString) != strlen($contentString)) print_error($result_array, 1);

	fclose($fh_ifcfg_eth1); /* ignore if fclose error */
	
	
	debug_print( "copy \"tmp-ifcfg-eth1\" to following ..." ) ;
	debug_print( "    <sandbox_controller> /etc/sysconfig/network-scripts/ifcfg-eth1" ) ;
	unset($result_array);
	exec("$BACKEND copy_file_from_server_to_vm_by_vix $esxi_ip $escaped_esxi_username $escaped_esxi_password $escaped_sandbox_controller_admin_username $escaped_sandbox_controller_admin_password \"$controller_vix_vmpath\" " . dirname(__FILE__) . "/tmp-ifcfg-eth1 /etc/sysconfig/network-scripts/ifcfg-eth1 2>&1", $result_array, $return_value);
	unlink(dirname(__FILE__) . "/tmp-ifcfg-eth1"); /* ignore if unlink error */
	if($return_value != 0) print_error($result_array, $return_value);
	

	/* setting network configuration for eth1:1 */
	debug_print( "create \"tmp-ifcfg-eth1:1\"" ) ;
	$result_array = array();
	array_push($result_array, "fopen error");
	$fh_ifcfg_eth1_1 = fopen(dirname(__FILE__) . "/tmp-ifcfg-eth1:1", "w");	
	if($fh_ifcfg_eth1_1 === false) print_error($result_array, 1);

	$contentString = sprintf("DEVICE=\"%s\"\nONBOOT=yes\nBOOTPROTO=static\nIPADDR=%s\nNETMASK=%s\n", $init_nic, $init_ipaddr, $init_netmask);
	$result_array = array();
	array_push($result_array, "fwrite error");
    if(fwrite($fh_ifcfg_eth1_1, $contentString) != strlen($contentString)) print_error($result_array, 1);

	fclose($fh_ifcfg_eth1_1); /* ignore if fclose error */
	
	debug_print( "copy \"tmp-ifcfg-eth1:1\" to following ..." ) ;
	debug_print( "    <sandbox_controller> /etc/sysconfig/network-scripts/ifcfg-$init_nic" ) ;
	unset($result_array);
	exec("$BACKEND copy_file_from_server_to_vm_by_vix $esxi_ip $escaped_esxi_username $escaped_esxi_password $escaped_sandbox_controller_admin_username $escaped_sandbox_controller_admin_password \"$controller_vix_vmpath\" " . dirname(__FILE__) . "/tmp-ifcfg-eth1:1 /etc/sysconfig/network-scripts/ifcfg-$init_nic 2>&1", $result_array, $return_value);
	unlink(dirname(__FILE__) . "/tmp-ifcfg-eth1:1"); /* ignore if unlink error */
	if($return_value != 0) print_error($result_array, $return_value);
	

	/* setting network configuration for eth1:2 */
	debug_print( "create \"tmp-ifcfg-eth1:2\"" ) ;
	$result_array = array();
	array_push($result_array, "fopen error");
	$fh_ifcfg_eth1_2 = fopen(dirname(__FILE__) . "/tmp-ifcfg-eth1:2", "w");
	if($fh_ifcfg_eth1_2 === false) print_error($result_array, 1);

	$contentString = sprintf("DEVICE=\"%s\"\nONBOOT=yes\nBOOTPROTO=static\nIPADDR=%s\nNETMASK=%s\n", $ctrl_nic, $ctrl_ipaddr, $ctrl_netmask);
	$result_array = array();
	array_push($result_array, "fwrite error");
    if(fwrite($fh_ifcfg_eth1_2, $contentString) != strlen($contentString)) print_error($result_array, 1);

	fclose($fh_ifcfg_eth1_2); /* ignore if fclose error */
	
	debug_print( "copy \"tmp-ifcfg-eth1:2\" to following ..." ) ;
	debug_print( "    <sandbox_controller> /etc/sysconfig/network-scripts/ifcfg-$ctrl_nic" ) ;
	unset($result_array);
	exec("$BACKEND copy_file_from_server_to_vm_by_vix $esxi_ip $escaped_esxi_username $escaped_esxi_password $escaped_sandbox_controller_admin_username $escaped_sandbox_controller_admin_password \"$controller_vix_vmpath\" " . dirname(__FILE__) . "/tmp-ifcfg-eth1:2 /etc/sysconfig/network-scripts/ifcfg-$ctrl_nic 2>&1", $result_array, $return_value);
	unlink(dirname(__FILE__) . "/tmp-ifcfg-eth1:2"); /* ignore if unlink error */
	if($return_value != 0) print_error($result_array, $return_value);
	

	/* setting routing table */
	debug_print( "create \"tmp-route_eth1\"" ) ;
	$result_array = array();
	array_push($result_array, "fopen error");
	$fh_route_eth1 = fopen(dirname(__FILE__) . "/tmp-route_eth1", "w");
	if($fh_route_eth1 === false) print_error($result_array, 1);

	$contentString = sprintf("ADDRESS0=%s\nNETMASK0=%s\nGATEWAY0=%s\n", $sandbox_default_net, $sandbox_default_netmask, $ctrl_gateway);
	$result_array = array();
    debug_print( "$contentString" ) ;
	array_push($result_array, "fwrite error");
    if(fwrite($fh_route_eth1, $contentString) != strlen($contentString)) print_error($result_array, 1);

	fclose($fh_route_eth1); /* ignore if fclose error */

	debug_print( "copy \"tmp-route_eth1\" to following ..." ) ;
	debug_print( "    <sandbox_controller> /etc/sysconfig/network-scripts/route-eth1" ) ;
	unset($result_array);
	exec("$BACKEND copy_file_from_server_to_vm_by_vix $esxi_ip $escaped_esxi_username $escaped_esxi_password $escaped_sandbox_controller_admin_username $escaped_sandbox_controller_admin_password \"$controller_vix_vmpath\" " . dirname(__FILE__) . "/tmp-route_eth1  /etc/sysconfig/network-scripts/route-eth1 2>&1", $result_array, $return_value);
	unlink(dirname(__FILE__) . "/tmp-route_eth1"); /* ignore if unlink error */
	if($return_value != 0) print_error($result_array, $return_value);
	
	debug_print( "launch \"/sbin/ifup eth1\" in sandbox_controller ..." ) ;
	exec("$BACKEND run_program_in_vm_by_vix $esxi_ip $escaped_esxi_username $escaped_esxi_password $escaped_sandbox_controller_admin_username $escaped_sandbox_controller_admin_password \"$controller_vix_vmpath\" /sbin/ifup eth1 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);
    
	debug_print( "create folder \"sandbox_controller_dir\"" ) ;	
	unset($result_array);
	exec("$BACKEND run_program_in_vm_by_vix $esxi_ip $escaped_esxi_username $escaped_esxi_password $escaped_sandbox_controller_admin_username $escaped_sandbox_controller_admin_password \"$controller_vix_vmpath\" /bin/mkdir -p $sandbox_controller_dir 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);

	debug_print( "copy \"connect_gateway.sh\" to following ..." ) ;
	debug_print( "    <sandbox_controller> $sandbox_controller_dir/connect_gateway.sh" ) ;
	unset($result_array);
	exec("$BACKEND copy_file_from_server_to_vm_by_vix $esxi_ip $escaped_esxi_username $escaped_esxi_password $escaped_sandbox_controller_admin_username $escaped_sandbox_controller_admin_password \"$controller_vix_vmpath\" " . dirname(__FILE__) . "/../connect_gateway.sh $sandbox_controller_dir/connect_gateway.sh 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);

	debug_print( "copy \"gateway.key\" to following ..." ) ;
	debug_print( "    <sandbox_controller> $sandbox_controller_dir/gateway.key" ) ;
	unset($result_array);
	exec("$BACKEND copy_file_from_server_to_vm_by_vix $esxi_ip $escaped_esxi_username $escaped_esxi_password $escaped_sandbox_controller_admin_username $escaped_sandbox_controller_admin_password \"$controller_vix_vmpath\" " . dirname(__FILE__) . "/../gateway.key $sandbox_controller_dir/gateway.key 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);

    debug_print( "change following files to be only readable for root (600): " ) ;
    debug_print( "    <sandbox_controller> $sandbox_controller_dir/gateway.key" ) ;
	unset($result_array);
	exec("$BACKEND run_program_in_vm_by_vix $esxi_ip $escaped_esxi_username $escaped_esxi_password $escaped_sandbox_controller_admin_username $escaped_sandbox_controller_admin_password \"$controller_vix_vmpath\" /bin/chmod 600 $sandbox_controller_dir/gateway.key 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);

	debug_print( "setup NAT ..." ) ;
	unset($result_array);
	exec("$BACKEND run_program_in_vm_by_vix $esxi_ip $escaped_esxi_username $escaped_esxi_password $escaped_sandbox_controller_admin_username $escaped_sandbox_controller_admin_password \"$controller_vix_vmpath\" $sandbox_controller_dir/connect_gateway.sh /setup.sh --role WILD --disable --role CTRL --type static --ipaddr $ctrl_gateway --netmask $ctrl_netmask  --outbound $ctrl_ipaddr --enable --role SANDBOX --type static --ipaddr $sandbox_default_gateway --netmask $sandbox_default_netmask --outbound $sandbox_default_gateway/$sandbox_default_netmask --enable 2>&1", $result_array, $return_value);
	if($return_value != 0) print_error($result_array, $return_value);
}
